/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWLogSubQuery;
import java.util.Date;

public final class VWLogQuery {
    protected VWLogSubQuery[] serverQueries = null;
    protected int numOfServers = 0;
    protected int lastServer = -1;
    protected VWLog querySource;
    protected VWLogElement[] nextTestElement = null;
    protected VWIndexDefinition indexDef = null;
    protected int FIELD_IS_EQUAL = 0;
    protected int FIELD_IS_GREATER = 1;
    protected int FIELD_IS_LESS = -1;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-03-17 17:05:56 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Lauren Nguyen;5D5845897;laurenng@us.ibm.com (lnguyen) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    protected VWLogQuery(VWLog querySource, String index_Name, Object[] min_Values, Object[] max_Values, int queryFlags, String pre_Filter_SQL, Object[] substitution_Vars, int query_Type) throws VWException {
        this.querySource = querySource;
        this.numOfServers = querySource.getServerCount();
        if (this.numOfServers > 0) {
            this.serverQueries = new VWLogSubQuery[this.numOfServers];
            for (int i = 0; i < this.numOfServers; ++i) {
                this.serverQueries[i] = new VWLogSubQuery(querySource.getSubLog(i), index_Name, min_Values, max_Values, queryFlags, pre_Filter_SQL, substitution_Vars, query_Type);
            }
            VWLogDefinition logDef = querySource.fetchLogDefinition();
            if (index_Name == null || index_Name.length() == 0) {
                index_Name = "F_LogTime";
            }
            this.indexDef = logDef.getIndex(index_Name);
            if (this.indexDef == null) {
                throw new VWException("vw.api.LQNoIndex", "No index definition found. {0}", index_Name);
            }
        } else {
            throw new VWException("vw.api.LQNoServers", "No servers found for log. {0}", querySource.getName());
        }
    }

    public VWLogElement next() throws VWException {
        VWLogElement result = null;
        if (this.nextTestElement == null) {
            this.nextTestElement = new VWLogElement[this.numOfServers];
            for (int i = 0; i < this.numOfServers; ++i) {
                this.nextTestElement[i] = this.serverQueries[i].next();
            }
            this.lastServer = 0;
        } else {
            this.nextTestElement[this.lastServer] = this.serverQueries[this.lastServer].next();
        }
        int newLastServer = this.lastServer;
        for (int i = 0; i < this.numOfServers; ++i) {
            if (this.lastServer == i || this.nextTestElement[i] == null || this.nextTestElement[newLastServer] != null && !this.returnR1BeforeR2(this.nextTestElement[i], this.nextTestElement[newLastServer])) continue;
            newLastServer = i;
        }
        this.lastServer = newLastServer;
        result = this.nextTestElement[this.lastServer];
        this.nextTestElement[this.lastServer] = null;
        return result;
    }

    public VWLog getLog() {
        return this.querySource;
    }

    public String toString() {
        return this.querySource.toString() + " LogQuery";
    }

    public void resetFetch() {
        for (int i = 0; i < this.numOfServers; ++i) {
            this.serverQueries[i].resetFetch();
        }
        this.nextTestElement = null;
    }

    public boolean hasNext() throws VWException {
        int i;
        boolean result = false;
        if (this.nextTestElement != null) {
            for (i = 0; i < this.numOfServers; ++i) {
                if (this.nextTestElement[i] == null) continue;
                result = true;
                break;
            }
        }
        if (!result) {
            for (i = 0; i < this.numOfServers; ++i) {
                if (!this.serverQueries[i].hasNext()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    boolean returnR1BeforeR2(VWLogElement log1, VWLogElement log2) throws VWException {
        String[] expFields = this.indexDef.getFieldNames();
        String name = null;
        Object lvalue1 = null;
        Object lvalue2 = null;
        int ltype1 = 0;
        int ltype2 = 0;
        for (int i = 0; i < expFields.length; ++i) {
            name = expFields[i];
            if (!log1.hasField(name)) {
                return true;
            }
            if (!log2.hasField(name)) {
                return false;
            }
            lvalue1 = log1.getFieldValue(name);
            lvalue2 = log2.getFieldValue(name);
            if (lvalue1 == null) {
                return true;
            }
            if (lvalue2 == null) {
                return false;
            }
            ltype1 = VWFieldType.getVWFieldType(lvalue1);
            if (ltype1 != (ltype2 = VWFieldType.getVWFieldType(lvalue2))) {
                throw new VWException("vw.api.LQReturnR1BeforeR2TypesIncompatable", "Field Types are not compatable. {0} {1} {2}", new Integer(ltype1), new Integer(ltype2), name);
            }
            if (ltype1 == -1) {
                throw new VWException("vw.api.LQReturnR1BeforeR2TypesIncompatable", "Field Type bad. {0} {1} {2}", new Integer(ltype1), name, lvalue1.getClass());
            }
            int cmpVal = this.compareFields(lvalue1, lvalue2, ltype1, name);
            if (cmpVal == 0) continue;
            return cmpVal < 0;
        }
        return false;
    }

    protected int compareFields(Object f1, Object f2, int fType, String name) throws VWException {
        switch (fType) {
            case 4: {
                boolean bf1 = (Boolean)f1;
                boolean bf2 = (Boolean)f2;
                if (bf1 && bf2 || !bf1 && !bf2) {
                    return this.FIELD_IS_EQUAL;
                }
                if (!bf1 && bf2) {
                    return this.FIELD_IS_LESS;
                }
                return this.FIELD_IS_GREATER;
            }
            case 1: {
                int if1 = (Integer)f1;
                int if2 = (Integer)f2;
                if (if1 < if2) {
                    return this.FIELD_IS_LESS;
                }
                if (if1 > if2) {
                    return this.FIELD_IS_GREATER;
                }
                return this.FIELD_IS_EQUAL;
            }
            case 8: {
                double df1 = (Double)f1;
                double df2 = (Double)f2;
                if (df1 < df2) {
                    return this.FIELD_IS_LESS;
                }
                if (df1 > df2) {
                    return this.FIELD_IS_GREATER;
                }
                return this.FIELD_IS_EQUAL;
            }
            case 2: 
            case 32: 
            case 64: {
                return ((String)f1).compareTo((String)f2);
            }
            case 16: 
            case 256: {
                long lf1 = ((Date)f1).getTime();
                long lf2 = ((Date)f2).getTime();
                if (lf1 < lf2) {
                    return this.FIELD_IS_LESS;
                }
                if (lf1 > lf2) {
                    return this.FIELD_IS_GREATER;
                }
                return this.FIELD_IS_EQUAL;
            }
        }
        throw new VWException("vw.api.LQCompareFieldsBadType", "Field Type is not expected. {0} {1}", new Integer(fType), name);
    }

    public int fetchCount() throws VWException {
        int result = 0;
        for (int i = 0; i < this.numOfServers; ++i) {
            result += this.serverQueries[i].fetchCount();
        }
        return result;
    }
}

